/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright        2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		PIUFile.cpp
//
//	Description:
//		File utilities for alias values acquired from the automation system.
//
//	Version history:
//		Version 1.0.0	7/10/2000	Created for Photoshop 6.0.
//			Written by Thomas Ruark.
//
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
//	Includes
//-------------------------------------------------------------------------------
#include "PIUFile.h"

#ifdef __PIMac__
static void pstrcat(StringPtr dst, StringPtr src);
static void pstrinsert(StringPtr dst, StringPtr src);
static void ptocstr(StringPtr src);
#endif

void AliasToFullPath(Handle aliasValue, char* fullPath)
{
	if (fullPath != NULL)
	{
		*fullPath = 0;
#ifdef __PIMac__
		OSErr err;
		Boolean wasChanged = false;
		FSSpec fileSpec;
		DirInfo block;
		Str255 directoryName;

		err = ResolveAlias(nil, (AliasRecord**)aliasValue, &fileSpec, &wasChanged);
		if (err != noErr) return;

		pstrinsert((unsigned char *)fullPath, fileSpec.name);
		
		block.ioDrParID = fileSpec.parID;
		block.ioNamePtr = directoryName;
		do {
			block.ioVRefNum = fileSpec.vRefNum;
			block.ioFDirIndex = -1;
			block.ioDrDirID = block.ioDrParID;
			err = PBGetCatInfo((CInfoPBRec*)&block, FALSE);
			if (err == noErr)
			{
				pstrcat(directoryName, (StringPtr)"\p:");
				pstrinsert((unsigned char *)fullPath, directoryName);
			}
		} while (block.ioDrDirID != 2);
		
		ptocstr((unsigned char*)fullPath);
				
#elif defined(__PIWin__)
		int32 length = sPSHandle->GetSize(aliasValue);
			
		Boolean oldLock = FALSE;
		Ptr pointer = NULL;
			
		sPSHandle->SetLock(aliasValue, true, &pointer, &oldLock);
			
		if (pointer != NULL)
		{
			strcpy(fullPath, pointer);
			sPSHandle->SetLock(aliasValue, oldLock, &pointer, &oldLock);
		}
			
		
	#endif
		}
}

void FullPathToAlias(char* fullPath, Handle& aliasValue)
{
	aliasValue = NULL;
#if __PIMac__
	NewAliasMinimalFromFullPath(strlen(fullPath),fullPath,nil,nil,&(AliasHandle)aliasValue);
#else
	Boolean oldLock;
	Ptr address;
    aliasValue = sPSHandle->New(strlen(fullPath)+1);
    if (aliasValue != NULL)
	{
		sPSHandle->SetLock(aliasValue, true, &address, &oldLock);
        strncpy(address, fullPath, strlen(fullPath)+1);
		sPSHandle->SetLock(aliasValue, false, &address, &oldLock);
    }
#endif
}

#if __PIMac__
static void pstrcat(StringPtr dst, StringPtr src)
{
	BlockMove(src + 1, dst + *dst + 1, *src);
	*dst += *src;
}

static void pstrinsert(StringPtr dst, StringPtr src)
{
	BlockMove(dst + 1, dst + *src + 1, *dst);
	BlockMove(src + 1, dst + 1, *src);
	*dst += *src;
}	

static void ptocstr(StringPtr src)
{	short len, i;

	len = src[0];

	for (i = 0; i < len; i++)
	{
		src[i] = src[i+1];
	}
	src[len] = '\0';
}
	
#endif